﻿using System;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;  

public partial class VTAPatient : BasePage
{
    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/Referral.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly VTADoDDataManager _manager;
    private VTA_PATIENT _patient;

    public VTAPatient()
    {
        _manager = new VTADoDDataManager();

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            int patientId;
            //only existing referrals
            if (int.TryParse(Request.QueryString["patientId"], out patientId))
            {                
                getRefreshVTAPatient(patientId);
            }

            SetupVTAPatient(_patient);

            SetReferringPage();
        }
    }
    
    private void getRefreshVTAPatient(int pId)
    {
        _patient = _manager.GetPatientVTAInfoByReferralId(pId);
    }

    private void SetupVTAPatient(VTA_PATIENT vtaPatient)
    {
        SnumLabel.Text = vtaPatient.patientsnum;
        LabelICN.Text = vtaPatient.patienticn;
        PatientNameLabel.Text = vtaPatient.PatientName;
        Address1Label.Text = vtaPatient.PatientAddress;
        CityLabel.Text = vtaPatient.city;
        StateLabel.Text = vtaPatient.state;
        ZipCodeLabel.Text = vtaPatient.ZIP;
        CountryLabel.Text = vtaPatient.country;
        HomePhoneLabel.Text = vtaPatient.home_phone;
        WorkPhoneLabel.Text = vtaPatient.work_phone;
        LabelOefOifIndicator.Text = vtaPatient.oefoifindicator.ToString();
        if (vtaPatient.dateofbirth.HasValue)
        {
            LabelDOB.Text = vtaPatient.dateofbirth.Value.ToString("d");
        }
        if (vtaPatient.dateofdeath.HasValue)
        {
            LabelDateOfDeath.Text = vtaPatient.dateofdeath.Value.ToString("d");
        }
        LabelGenderCode.Text = vtaPatient.gender_code;
        LabelServiceBranch.Text = vtaPatient.svcbranch_code;
    }

    protected void BackButton_OnClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR_REFERRAL";
    }

    public override string AppObjectCode()
    {
        return "EFR_REFERRAL";
    }

}
